using System;
using System.Data;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using Method = System.Reflection.MethodBase;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for PatientSpecialInstruction.
	/// </summary>
	public class PatientSpecialInstruction : BaseBusinessObject, IRecordStatusCode
	{
		private System.Guid _patientSpecialInstructionGUID, patientGUID;
		// Is this variable/ property needed?  Ask K.
		//private BOL.Patient _patient;
		private string _patientSpecialInstructions;

		private System.DateTime _createDate;
		private string _createUser;
		
		private bool _vistaConversionIndicator;
		private string _inactivationComment;
		private string _inactivationDetails;

		private System.DateTime _inactivateDate;
		private string _inactivateUser;

		// Is this variable/ property needed?  Ask K.
		//private BOL.CannedComment _cannedComment;
		private string _divisionCode;
		private Common.RecordStatusCode _statusCode;
		// inactivation 


		
		#region constructors

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3167"> 
		///		<ExpectedInput>Valid patient object, special instructions, and division code</ExpectedInput>
		///		<ExpectedOutput>PatientSpecialInstruction object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3168"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		public PatientSpecialInstruction(BOL.Patient patient, string patientSpecialInstructions, string divisionCode)
		{
			if (patient == null || patientSpecialInstructions == null || patientSpecialInstructions == string.Empty ||
				divisionCode == null || divisionCode == string.Empty)
			{
				throw new ArgumentException(Common.StrRes.SysErrMsg.Common.InvalidArgument("ordered unit and/or patient special instructions and/or division code").ResString);
			}

			this.PatientSpecialInstructionGuid = System.Guid.NewGuid();
			System.DateTime currentDate = VBECSDateTime.GetDivisionCurrentDateTime();
			this.patientGUID = patient.PatientGuid;
			this.PatientSpecialInstructions = patientSpecialInstructions;
			this.VistaConversionIndicator = false;
			this.RecordStatusCode = Common.RecordStatusCode.Active;
			this.LastUpdateDate = currentDate;
			this.CreateDate = currentDate;
			this.CreateUser = Common.LogonUser.LogonUserName;
			if (divisionCode == null || divisionCode.Trim().Length == 0)
			{
				string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod(
										Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name),
										"division code may not be null or empty").ResString;
				throw new BusinessObjectException(errorMessage);
			}
			this.DivisionCode = divisionCode;
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3169"> 
		///		<ExpectedInput>Valid datarow</ExpectedInput>
		///		<ExpectedOutput>PatientSpecialInstruction object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3170"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientSpecialInstruction
		/// </summary>
		/// <param name="dr"></param>
		public PatientSpecialInstruction(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		#endregion


		#region properties

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2652"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="475"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Patient special instruction GUID
		/// </summary>
		public Guid PatientSpecialInstructionGuid
		{
			get
			{
				return this._patientSpecialInstructionGUID;
			}
			set
			{
				this._patientSpecialInstructionGUID = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2654"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2655"> 
		///		<ExpectedInput>Invalid string Length</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///Special instructions for a patient 
		/// </summary>
		public string PatientSpecialInstructions
		{
			get
			{
				return this._patientSpecialInstructions;
			}
			set
			{
				if (value.Trim().Length == 0  || value.Trim().Length > 255)
				{
					string errorMessage = Common.StrRes.SysErrMsg.Common.FieldLengthError(
											Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true),
											"0", "256").ResString;
					throw new BusinessObjectException(errorMessage);
				}
				else
				{
					this._patientSpecialInstructions = value;
				}
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2656"> 
		///		<ExpectedInput>DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2657"> 
		///		<ExpectedInput>Invalid DateTime</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Date/time patient special instruction is created
		/// </summary>
		public System.DateTime CreateDate
		{
			get
			{
				return this._createDate;
			}
			set
			{
				if (value == DateTime.MinValue || value == DateTime.MaxValue)
				{
					string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod(
											Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true),
											value).ResString;
					throw new BOL.BusinessObjectException(errorMessage);
				}
				else
				{
					this._createDate = value;
				}
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2658"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="459"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// User who created patient special instruction
		/// </summary>
		public string CreateUser
		{
			get
			{
				return this._createUser;
			}
			set
			{
				this._createUser = value;
			}
		}
	

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2662"> 
		///		<ExpectedInput>Bool</ExpectedInput>
		///		<ExpectedOutput>Bool</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="477"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Boolean which indicates if the special instruction was converted from VISTA
		/// </summary>
		public bool VistaConversionIndicator
		{
			get
			{
				return this._vistaConversionIndicator;
			}
			set
			{
				this._vistaConversionIndicator = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2664"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="471"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Comment when the special instruction is deactivated
		/// </summary>
		public string InactivationComment
		{
			get
			{
				return this._inactivationComment;
			}
			set
			{
				this._inactivationComment = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2666"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="472"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Details when the special instruction is deactivated
		/// </summary>
		public string InactivationDetails
		{
			get
			{
				return this._inactivationDetails;
			}
			set
			{
				this._inactivationDetails = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2668"> 
		///		<ExpectedInput>Valid DateTime</ExpectedInput>
		///		<ExpectedOutput>DateTime</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2669"> 
		///		<ExpectedInput>Invalid DateTime</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Date when the special instruction is deactivated
		/// </summary>
		public System.DateTime InactivateDate
		{
			get
			{
				return this._inactivateDate;
			}
			set
			{
				if (value == DateTime.MaxValue)
				{
					string errorMessage = Common.StrRes.SysErrMsg.Common.InvalidPropertyOrMethod(
											Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true),
											value).ResString;
					throw new BOL.BusinessObjectException(errorMessage);
				}
				else
				{
					this._inactivateDate = value;
				}
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2670"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="470"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// User who  deactivated the special instruction
		/// </summary>
		public string InactivateUser
		{
			get
			{
				return this._inactivateUser;
			}
			set
			{
				this._inactivateUser = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2672"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="469"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Division code 
		/// </summary>
		public string DivisionCode
		{
			get
			{
				return this._divisionCode;
			}
			set
			{
				this._divisionCode = value;
			}
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2674"> 
		///		<ExpectedInput>Common.RecordStatusCode</ExpectedInput>
		///		<ExpectedOutput>Common.RecordStatusCode</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="476"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Status of special instruction record
		/// </summary>
		public Common.RecordStatusCode RecordStatusCode
		{
			get
			{
				return this._statusCode;
			}
			set
			{
				this._statusCode = value;
			}
		}

		#endregion


		#region methods


		///		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/9/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7314"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7315"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a boolean indicating if the SI matches a TR (BR_37.09)
		/// </summary>
		///
		public static bool SITextMatchesTR(string siText)
		{
			string patternOne = "^(irradiat|leukored|leukocyte reduc|wash|sickle|cmv)$";
			string patternTwo = "(irradiat|leukored|leukocyte reduc|wash|sickle|cmv)";

			// BR_37.09
			Regex _regexSI = new Regex(patternOne, RegexOptions.IgnoreCase);	
			Regex _regexSI2 = new Regex(patternTwo, RegexOptions.IgnoreCase);
			return (_regexSI.IsMatch(siText,0) || _regexSI2.IsMatch(siText,0));
		}


		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2676"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2677"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a data table of special instructions for a patient 
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataTable GetSpecialInstructionsForPatient(Guid patientGuid)
		{
			DataTable dtSpecialInstructions = DAL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(patientGuid);
			return dtSpecialInstructions;
		}
		
		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/12/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7563"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7564"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// DoActiveSpecialInstructionsExistForPatient
		/// </summary>
		/// <param name="patientGuid">Patient GUID</param>
		/// <returns></returns>
		public static bool DoActiveSpecialInstructionsExistForPatient(Guid patientGuid)
		{
			DataTable dtSpecialInstructions = DAL.PatientSpecialInstruction.GetSpecialInstructionsForPatient(patientGuid);
			DataRow [] drArray = dtSpecialInstructions.Select("RecordStatusCode = '" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active) + "' OR RecordStatusCode = '" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Converted) + "'"  );
			if (drArray != null && drArray.Length > 0) return true;
			else return false;
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3179"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="473"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///		/// <summary>
		/// Returns an empty SpecialInstructionsTable
		/// </summary>
		/// <returns></returns>
		public static DataTable InitializeSpecialInstructionsTable(bool isUpdate)
		{
			DataTable dtSpecialInstructions = new DataTable();

			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.PatientSpecialInstructionGuid, typeof(System.Guid));	//Required
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.PatientGuid, typeof(System.Guid));						//Required
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.PatientSpecialInstructions, typeof(string));			//Required
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.CreateDate, typeof(System.DateTime));
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.CreateUser, typeof(string));
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.VistaConversionIndicator, typeof(bool));
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.InactivationComment, typeof(string));
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.InactivateDate, typeof(System.DateTime));
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.InactivateUser, typeof(string));
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.DivisionCode, typeof(string));							//Required
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.RecordStatusCode, typeof(string));						//Required
			dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.LastUpdateUser, typeof(string));						//Required
			if (isUpdate)
				dtSpecialInstructions.Columns.Add(TABLE.PatientSpecialInstruction.RowVersion, typeof(byte[]));							//Required

			return dtSpecialInstructions;
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2678"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="474"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns>Date row</returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			return dtRow;
		}
		
		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.PatientSpecialInstructionGuid))
			{
				this.PatientSpecialInstructionGuid = dtRow.IsNull(TABLE.PatientSpecialInstruction.PatientSpecialInstructionGuid) ? Guid.NewGuid() :  (Guid) dtRow[TABLE.PatientSpecialInstruction.PatientSpecialInstructionGuid];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.PatientSpecialInstructions))
			{
				this.PatientSpecialInstructions = dtRow.IsNull(TABLE.PatientSpecialInstruction.PatientSpecialInstructions) ? String.Empty : dtRow[TABLE.PatientSpecialInstruction.PatientSpecialInstructions].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.CreateDate))
			{
				this.CreateDate  = dtRow.IsNull(TABLE.PatientSpecialInstruction.CreateDate) ? DateTime.MinValue : (System.DateTime) dtRow[TABLE.PatientSpecialInstruction.CreateDate];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.CreateUser))
			{
				this.CreateUser  = dtRow.IsNull(TABLE.PatientSpecialInstruction.CreateUser) ? String.Empty : dtRow[TABLE.PatientSpecialInstruction.CreateUser].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.VistaConversionIndicator))
			{
				this.VistaConversionIndicator = dtRow.IsNull(TABLE.PatientSpecialInstruction.VistaConversionIndicator) ? false : (bool) dtRow[TABLE.PatientSpecialInstruction.VistaConversionIndicator];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.InactivationComment))
			{
				this.InactivationComment = dtRow.IsNull(TABLE.PatientSpecialInstruction.InactivationComment) ? String.Empty : dtRow[TABLE.PatientSpecialInstruction.InactivationComment].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.InactivateDate))
			{
				//dataRow["LocalSupplierGuid"] = dataRow.IsNull("LocalSupplierGuid") ? Guid.Empty : (Guid) dataRow["LocalSupplierGuid"];
				this.InactivateDate  = dtRow.IsNull(TABLE.PatientSpecialInstruction.InactivateDate) ? System.DateTime.MinValue : (System.DateTime) dtRow[TABLE.PatientSpecialInstruction.InactivateDate];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.InactivateUser))
			{
				this.InactivateUser  = dtRow.IsNull(TABLE.PatientSpecialInstruction.InactivateUser) ? String.Empty : dtRow[TABLE.PatientSpecialInstruction.InactivateUser].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.DivisionCode))
			{
				this.DivisionCode = dtRow.IsNull(TABLE.PatientSpecialInstruction.DivisionCode) ? String.Empty : dtRow[TABLE.PatientSpecialInstruction.DivisionCode].ToString();
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.RecordStatusCode))
			{
				this.RecordStatusCode = dtRow.IsNull(TABLE.PatientSpecialInstruction.RecordStatusCode) ? Common.RecordStatusCode.Unknown : Common.Utility.GetRecordStatusCodeFromString(dtRow[TABLE.PatientSpecialInstruction.RecordStatusCode].ToString());
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.LastUpdateDate))
			{
				this.LastUpdateDate = dtRow.IsNull(TABLE.PatientSpecialInstruction.LastUpdateDate) ? DateTime.MinValue : (System.DateTime) dtRow[TABLE.PatientSpecialInstruction.LastUpdateDate];
			}
			if (dtRow.Table.Columns.Contains(TABLE.PatientSpecialInstruction.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.PatientSpecialInstruction.RowVersion))
				{
					this.RowVersion = (byte[]) dtRow[TABLE.PatientSpecialInstruction.RowVersion];
				}
			}
		}




		
		#endregion


		#region events
		
		#endregion

	}
}
